// Library : 'FishinoLowPower' -- File : 'FishinoLowPower.h'
// Created by FishIDE application 
#ifndef __FISHINOLOWPOWER_FISHINOLOWPOWER_H
#define __FISHINOLOWPOWER_FISHINOLOWPOWER_H

// catch all interrupt, if we don't define any ISR to handle
// wake interrupt -- declared WEAK so it can be redefined
#ifdef __cplusplus
	extern "C" {
#endif
	void badInterrupt(void) __attribute__((weak));
#ifdef __cplusplus
	}
#endif

#include <Fishino.h>

#if defined(_FISHINO_MEGA_)

	// ESP to Atmega wake up pin for Fishino MEGA
	// you can choose between those I/O; you MUST wire this I/O with I/O 7 on MEGA board
	//
	// 2, 3 (external interrupts, INT4, INT5))
	// 10..13 (pin change interrupts, PB4..PB7, PCINT4..PCINT7)
	// 14, 15 (pin change interrupt, PJ1, PJ0, PCINT10, PCINT9)
	// 18..21 (external interrupts, 20 and 21 are also used for I2C, not recommended, PD3..PD0, INT3..INT0)
	// A8..A15 (PK0..PK7, pin change interrupt, PCINT16..PCINT23)
	#define ESP_INT_PIN		12
	//
	// ESP_CHPD_PIN
	// Pin connected to ESP CH_PD pin, used to power down the WiFi chip
	// you can choose any free pin, besides the one chosen above
	// you MUST connect this I/O with CH_PD pin on ESPCONN connector
	#define ESP_CHPD_PIN	11
	
#elif defined(_FISHINO_UNO_) || defined(_FISHINO_GUPPY_)

	// ESP to Atmega wake up pin for Fishino UNO and GUPPY
	// it is fixed at I/O 7, as it can be triggered by an interrupt and it's already
	// connected inside the board to GPIO16 on ESP module
	#define ESP_INT_PIN		7
	//
	// ESP_CHPD_PIN
	// Pin connected to ESP CH_PD pin, used to power down the WiFi chip
	// you can choose any free pin; we default to I/O 3 which is usually free
	// you MUST connect this I/O with CH_PD pin on ESPCONN connector
	#define ESP_CHPD_PIN	3
	
#elif defined(FISHINO32)

	#define ESP_CHPD_PIN	31

#elif defined(FISHINO_PIRANHA)

	#define ESP_CHPD_PIN	32

#else
	#error "Unsupported board"
#endif


class FishinoLowPower
{
	private:
		
	protected:

	public:
		
		// put board on sleep for requested time
		// REMEMBER - on 8 bit boards this needs wiring!
		static void deepSleep(uint32_t ms);
		
		// switch wifi module power
		static void wifiOff(void);
		static void wifiOn(void);
		
		// enable wakeup from external pin state change
		static bool enableInterruptPin(uint16_t pin, bool enable = true);
		static bool disableInterruptPin(uint16_t pin) { return enableInterruptPin(pin, false); }
		
		// enable wakeup by serial ports
		// note : enabled peripherals must be ON, so they use power
		static void enableSerialWakeup(bool enable = true);
		static void disableSerialWakeup(void) { enableSerialWakeup(false); }
		
		static void enableSerial0Wakeup(bool enable = true);
		static void disableSerial0Wakeup(void) { enableSerialWakeup(false); }
		
		static void enableSerial1Wakeup(bool enable = true);
		static void disableSeria1lWakeup(void) { enableSerialWakeup(false); }
		
		static void enableSerial2Wakeup(bool enable = true);
		static void disableSerial2Wakeup(void) { enableSerialWakeup(false); }
		
		static void enableSerial3Wakeup(bool enable = true);
		static void disableSerial3Wakeup(void) { enableSerialWakeup(false); }
		
		// enable I2C/Wire wakeup
		static void enableI2CWakeup(bool enable = true);
		static void disableI2CWakeup(void) { enableI2CWakeup(false); }
};

#endif
