#include "FishinoLowPower.h"

// switch wifi module power
void FishinoLowPowerClass::wifiOff(void)
{
	// do nothing if already disabled
	if(_wifiDisabled)
		return;
	
	// mark as disabled
	_wifiDisabled = true;
	
	// shut it down
	digitalWrite(ESP_CHPD_PIN, LOW);
	pinMode(ESP_CHPD_PIN, OUTPUT);
}

void FishinoLowPowerClass::wifiOn(void)
{
	if(!_wifiDisabled)
		return;
	
	// put ESP in OFF mode, just to be sure
	digitalWrite(ESP_CHPD_PIN, LOW);
	pinMode(ESP_CHPD_PIN, OUTPUT);
	
	// CS must be low to correctly re-boot ESP module
	// otherwise it'll boot in sd mode
	digitalWrite(WIFICS, LOW);
	pinMode(WIFICS, OUTPUT);

	// give ESP some time to get it
	delay(50);

	// wake up esp
	digitalWrite(ESP_CHPD_PIN, HIGH);
	
	// give it some time to start boot
	// (mandatory too!!!)
	delay(50);
	
	// deselect it again
	digitalWrite(WIFICS, HIGH);
	
	// mark as enabled
	_wifiDisabled = false;
}

FishinoLowPowerClass &__getFishinoLowPowerClass()
{
	static FishinoLowPowerClass lp;
	return lp;
}


